<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\DynamicPageController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CareerController;
use App\Http\Controllers\PageCategoryController;
use App\Http\Controllers\NotificationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('auth.login');
// });

Route::controller(IndexController::class)->group(function () {

    Route::get('/', 'index')->name('user.home');

    Route::get('/about', 'AboutUs')->name('user.about');
    Route::get('/volunteer', 'volunteer')->name('user.volunteer');
    Route::get('/privacy-policy', 'PrivacyPolicy')->name('user.privacy.policy');
    Route::get('/terms-and-conditions', 'TermsConditions')->name('user.terms.conditions');
    Route::get('/contact', 'contact')->name('user.contact');
    Route::get('/cancellation-and-refund-policy', 'RefundPolicy')->name('user.cancellation.refund');
    Route::get('/404', 'ErrorPage')->name('user.error.page');
    Route::get('/donate-yaan-foundation', 'DonateFoundation')->name('user.donate.foundation');
    Route::get('/blog', 'Blog')->name('user.blog.page');

    // Blog Dynamic
    Route::get('/blog-details/{slug?}', 'BlogDetails')->name('user.blog.details');

    Route::post('/contact-submit', 'ContactSubmit')->name('user.contact.submit');
    Route::post('/volunteer-submit', 'VolunteerSubmit')->name('user.volunteer.submit');
    Route::post('/donate-submit', 'DonateSubmit')->name('user.donate.submit');

    Route::get('refresh_captcha', 'refreshCaptcha')->name('refresh_captcha');
});

Route::post('/user_login', [App\Http\Controllers\IndexController::class, 'UserLogin'])->name('user.login');
Route::get('/offline', function () {
    return view('vendor.laravelpwa.offline');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::post('fetch-staff', [App\Http\Controllers\TaskController::class, 'fetchStaff'])->name('task.staff.fetch');
Route::post('admin-fetch-staff', [App\Http\Controllers\Admin\TaskController::class, 'fetchStaff'])->name('admin.task.staff.fetch');

// Route::post('user-logout', [App\Http\Controllers\HomeController::class, 'UserLogout'])->name('user.login');


Route::group(['prefix'=>'super-admin'],function (){
    Route::middleware(['super_admin', 'auth'])->group(function() {

        Route::get('', [App\Http\Controllers\HomeController::class, 'admin_index'])->name('admin.index');
        Route::get('/profile', [App\Http\Controllers\HomeController::class, 'AdminProfile'])->name('admin.profile');
        Route::post('/profile/upload/{id}', [App\Http\Controllers\HomeController::class, 'AdminProfileUpload'])->name('admin.profile.upload');

        Route::group(['prefix'=>'pages'],function (){
            Route::controller(DynamicPageController::class)->group(function () {

                Route::get('/create', 'create')->name('admin.pages.create');
                Route::get('/view', 'view')->name('admin.pages.view');
                Route::get('/edit/{id}', 'edit')->name('admin.pages.edit');
                Route::get('/delete/{id}', 'delete')->name('admin.pages.delete');

                Route::post('/store', 'store')->name('admin.pages.store');
                Route::post('/update/{id}', 'update')->name('admin.pages.update');

            });
        });

        Route::group(['prefix'=>'page-category'],function (){
            Route::controller(PageCategoryController::class)->group(function () {
                Route::get('/view', 'view')->name('admin.page.category.view');
                Route::get('/delete/{id}', 'delete')->name('admin.page.category.delete');

                Route::post('/edit', 'edit')->name('admin.page.category.edit');
                Route::post('/store', 'store')->name('admin.page.category.store');
            });
        });


        Route::group(['prefix'=>'blogs'],function (){
            Route::controller(BlogController::class)->group(function () {

                Route::get('/create', 'create')->name('admin.blog.create');
                Route::get('/view', 'view')->name('admin.blog.view');
                Route::get('/edit/{id}', 'edit')->name('admin.blog.edit');
                Route::get('/delete/{id}', 'delete')->name('admin.blog.delete');

                Route::post('/store', 'store')->name('admin.blog.store');
                Route::post('/update/{id}', 'update')->name('admin.blog.update');

            });
        });

        Route::group(['prefix'=>'careers'],function (){
            Route::controller(CareerController::class)->group(function () {
                Route::get('/view', 'view')->name('admin.careers.view');
                Route::get('/delete/{id}', 'delete')->name('admin.careers.delete');

                Route::post('/edit', 'edit')->name('admin.careers.edit');
                Route::post('/store', 'store')->name('admin.careers.store');
            });
        });

        Route::group(['prefix'=>'notification'],function (){
            Route::controller(NotificationController::class)->group(function () {
                Route::get('', 'ViewAdminNotification')->name('admin.notification.view');
                Route::post('/status', 'NotificationAdminUpdate')->name('admin.notification.update');
            });
        });

    });
});

