@extends('layouts.sub_admin')

@section('content')
<div class="content-wrapper">
      <div class="container-full">
        <!-- Main content -->
        <?php
            
            $total_staff     = \App\Models\User::where('sub_admin_id', Auth::user()->id)->where('user_type', 'staff')->get();
            $total_recurring     = \App\Models\Task::where('sub_admin_id', Auth::user()->id)->where('task_type', 'recurring')->get();
            // $total_task      = \App\Models\TaskStaff::where('sub_admin_id', Auth::user()->id)->get();
            // $pending         = \App\Models\TaskStaff::where('sub_admin_id', Auth::user()->id)->where('status', 'pending')->get();
            $project_id = Auth::user()->id;

            $total_task = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->get();

            $pending = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'pending')->get();

            $staff_com = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'user_completed')->get();


            $progress = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'inprogress')->get();

            $completed = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'completed')->get();

            $rejected = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'rejected')->get();

            $over_due = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'over_due')->get();

            $recomand = \App\Models\TaskStaff::with(['task_details'])->whereHas('task_details', function ($query) use ($project_id){
                    $query->where('sub_admin_id', '=', $project_id);
                })->where('status', 'recommend_to_admin')->get();

            // $recurring       = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('task_type', 'recurring')->get();
            // dd($book_details);

            // $staff_com       = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('status', 'user_completed')->get();
            // $progress        = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('status', 'inprogress')->get();
            // $completed       = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('status', 'completed')->get();
            // $rejected        = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('status', 'rejected')->get();
            // $recurring       = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('task_type', 'recurring')->get();
            // $over_due        = \App\Models\TaskStaff::with(['task_details'=>function($qry){
            //                                           $qry->where('sub_admin_id', Auth::user()->id);
            //                                       }])->where('status', 'over_due')->get();
            // dd($total_task);
        ?>

        <style>
            .box_color1
            {
                background-color: #9b7693;
                color: #fff;
                text-decoration: blink;
            }
            .box_color2
            {
                background-color: #68928c;
                color: #fff;
                text-decoration: blink;
            }
            .box_color3
            {
                background-color: #5fbc87;
                color: #fff;
                text-decoration: blink;
            }
            .box_color4
            {
                background-color: #e76b48;
                color: #fff;
                text-decoration: blink;
            }
            .box_color5
            {
                background-color: #007da5;
                color: #fff;
                text-decoration: blink;
            }
            .box_color6
            {
                background-color: #ff7096;
                color: #fff;
                text-decoration: blink;
            }
        </style>
        <section class="content">
            <div class="row">
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.view') }}" class="box box_color1">
                        <div class="box-body">
                            <span class="text-white icon-User fs-40"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path3"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Staff</div>
                            <div class="text-white fs-24 fw-800">{{ count($total_staff) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('sub.task.view') }}" class="box box_color2">
                        <div class="box-body">
                            <span class="text-white mdi mdi-ticket-confirmation fs-30"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($total_task) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('sub.task.recurring.view') }}" class="bg-hover-danger box box_color1">
                        <div class="box-body">
                            <span class="text-white mdi mdi-ticket-confirmation fs-30"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Recurring Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($total_recurring) }}</div>
                        </div>
                    </a>
                </div>
                <?php
                    $total_incentive = 0;
                    $incentive_details = \App\Models\Incentive::where('user_id', Auth::user()->id)->get();
                    if (count($incentive_details) > 0) {
                        foreach ($incentive_details as $key => $value) {
                            $total_incentive += $value->amount;
                        }
                    }
                ?>
                @if($total_incentive)
                <div class="col-lg-2 col-12">
                    <a href="{{ route('staff.incentive') }}" class="box box_color4">
                        <div class="box-body">
                            <span class="text-white icon-Equalizer fs-40"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path3"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Incentive Amount</div>
                            <div class="text-white  fs-24 fw-800">{{ number_format($total_incentive, 2) }}</div>
                        </div>
                    </a>
                </div>
                @endif
            </div>
            <hr>
            <div class="row">
                
                <div class="col-lg-3 col-12">
                    <a href="{{ url('/') }}/sub_admin/task/view-task?&task_status=completed" class="box box_color4">
                        <div class="box-body">
                            <span class="text-white icon-Smile fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Progress Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($progress) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ url('/') }}/sub_admin/task/view-task?&task_status=over_due" class="box bg-danger bg-hover-danger">
                        <div class="box-body">
                            <i class="icon-File" style="font-size: 40px;color: #fff;"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path3"></span></i>
                            <div class="text-white fw-600 fs-18 mb-2">Total Over Due Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($over_due) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ url('/') }}/sub_admin/task/view-task?&task_status=user_completed" class="box bg-info bg-hover-info">
                        <div class="box-body">
                            <span class="text-white icon-Chart-line fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Staff Completed</div>
                            <div class="text-white fs-24 fw-800">{{ count($staff_com) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ url('/') }}/sub_admin/task/view-task?&task_status=recommend_to_admin" class="box box_color2">
                        <div class="box-body">
                            <span class="text-white icon-User fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Recommend Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($recomand) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ url('/') }}/sub_admin/task/view-task?&task_status=completed" class="box bg-warning bg-hover-warning">
                        <div class="box-body">
                            <span class="text-white icon-Money fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Closed Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($completed) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ url('/') }}/sub_admin/task/view-task?&task_status=rejected" class="box box_color5">
                        <div class="box-body">
                            <span class="text-white icon-Attachment1 fs-40"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Rejected Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($rejected) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-4 col-12">
                    <?php
                        $today_order_amount = 0;
                        $today_order_amount1 = 0;
                        $month_order_amount = 0;
                        $month_order_amount1 = 0;
                        $today_receive_amount = 0;
                        $today_cancel_amount = 0;
                        $month_receive_amount = 0;
                        $month_cancel_amount = 0;
                        $today_date = date('Y-m-d');
                        // $today_date = "2025-01-06";
                        $this_month = now()->month;
                        $this_year = now()->year;

                        $today_project = \App\Models\Project::where('created_at', 'like', '%'.$today_date.'%')->get();
                        $today_cancel_project = \App\Models\Project::where('created_at', 'like', '%'.$today_date.'%')->where('status', 6)->get();
                        $month_project = \App\Models\Project::whereMonth('created_at', $this_month)->get();
                        $month_cancel_project = \App\Models\Project::whereMonth('created_at', $this_month)->where('status', 6)->get();

                        if ($today_project) {
                            foreach ($today_project as $key => $value) {
                                $today_order_amount += $value->bid_amount;
                                $today_bid = \App\Models\ProjectBitAmount::where('fld_project_id', $value->id)->get();
                                if ($today_bid) {
                                    foreach ($today_bid as $key3 => $value3) {
                                        $today_receive_amount += $value3->fld_project_amount;
                                    }
                                }
                            }
                        }
                        if ($today_cancel_project) {
                            foreach ($today_cancel_project as $key => $value) {
                                $today_order_amount1 += $value->bid_amount;
                                $today_bid = \App\Models\ProjectBitAmount::where('fld_project_id', $value->id)->get();
                                if ($today_bid) {
                                    foreach ($today_bid as $key3 => $value3) {
                                        $today_cancel_amount += $value3->fld_project_amount;
                                    }
                                }
                            }
                        }

                        if ($month_project) {
                            foreach ($month_project as $key1 => $value1) {
                                $month_order_amount += $value1->bid_amount;
                                $month_bid = \App\Models\ProjectBitAmount::where('fld_project_id', $value1->id)->get();
                                if ($month_bid) {
                                    foreach ($month_bid as $key4 => $value4) {
                                        $month_receive_amount += $value4->fld_project_amount;
                                    }
                                }
                            }
                        }

                        if ($month_cancel_project) {
                            foreach ($month_cancel_project as $key1 => $value1) {
                                $month_order_amount1 += $value1->bid_amount;
                                $month_bid = \App\Models\ProjectBitAmount::where('fld_project_id', $value1->id)->get();
                                if ($month_bid) {
                                    foreach ($month_bid as $key4 => $value4) {
                                        $month_cancel_amount += $value4->fld_project_amount;
                                    }
                                }
                            }
                        }
                        // dump($month_project);
                    ?>

                    <a class="box" style="background: #2d2d2d;">
                        <div class="box-body">
                            <div class="row">
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">Today Order Value ({{ date('d-m-Y') }})</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($today_order_amount, 2) }} <span onclick="OrderAmount('{{ $today_date }}')" style="border: 1px solid #fff;border-radius: 50px;padding: 0px 4px;cursor: pointer;"><i class="ti-eye text-white" style="font-size: 13px;margin-top: -4px;position: relative;top: -1px;"></i></span>
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">Received Amount</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($today_receive_amount, 2) }}
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">Cancel Amount</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($today_cancel_amount, 2) }}
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">This Month Order Value</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($month_order_amount, 2) }} <span onclick="TotalOrderAmount('{{ $this_month }}', '{{$this_year}}')" style="border: 1px solid #fff;border-radius: 50px;padding: 0px 4px;cursor: pointer;"><i class="ti-eye text-white" style="font-size: 13px;margin-top: -4px;position: relative;top: -1px;"></i></span>
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">This Month Received Amount</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($month_receive_amount, 2) }}
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">This Month Cancel Amount</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($month_cancel_amount, 2) }}
                                </div>
                            </div>
                        </div>
                    </a>
                    
                </div>
                
            </div>

            
        </section>
        <!-- /.content -->
      </div>
</div>
<div class="modal fade" id="modal-default">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Today Order Details</h4>
            <span class="btn-close" data-bs-dismiss="modal" aria-label="Close"></span>
          </div>
          <div class="modal-body" id="load_html">

          </div>
      </div>
  </div>
</div>
<script type="text/javascript">
    function OrderAmount(ref) {
        
        var ele = ref;
        // alert(ele);
        $.ajax({
            url: '{{ route('sub_admin.project.details') }}',
            method: "POST",
            data: {
                _token: '{{ csrf_token() }}', 
                product_id: ele
            },
            success: function (response) {
                // console.log(response);
                $("#load_html").html(response.html);
                $('#modal-default').modal('show');
            }
        });

    }

    function TotalOrderAmount(month, year)
    {
        // alert(month, year);
        var month = month;
        var year = year;
        
        var expert_search_url   = "{{ url('/') }}/sub_admin/this-month-projects";
        var str_search_request   = expert_search_url + '/' + month + '/' + year;
        
        if(str_search_request){
            window.location.href = str_search_request;
        }

    }
</script>
@endsection
