@extends('layouts.staff')

@section('content')
<div class="content-wrapper">
      <div class="container-full">
        <!-- Main content -->
        <?php
            
            $admin_review   = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->where('status', 'user_completed')->get();
            $pending        = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->where('status', 'pending')->get();
            $progress       = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->where('status', 'inprogress')->get();
            $completed      = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->where('status', 'completed')->get();
            $rejected       = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->where('status', 'rejected')->get();
            $recurring       ="0";
            $over_due        = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->where('status', 'over_due')->get();
            $total_task      = \App\Models\TaskStaff::where('staff_id', Auth::user()->id)->get();

            $admin_review_rer   = 0;
            $pending_rer        = 0;
            $progress_rer       = 0;
            $completed_rer      = 0;
            $rejected_rer       = 0;
            $recurring_rer      = 0;
            $over_due_rer       = 0;
            $total_task_rer     = 0;
            $total_recurring     = \App\Models\Task::where('staff_id', Auth::user()->id)->where('task_type', 'recurring')->get();

            // dd($rejected);
        ?>
        <style>
            .box_color1
            {
                background-color: #9b7693;
            }
            .box_color2
            {
                background-color: #68928c;
            }
            .box_color3
            {
                background-color: #5fbc87;
            }
            .box_color4
            {
                background-color: #e76b48;
            }
            .box_color5
            {
                background-color: #007da5;
            }
            .box_color6
            {
                background-color: #ff7096;
            }
        </style>
        <section class="content">

            <div class="row">
                <div class="col-lg-3 col-12">
                    <a href="#" class="box box_color6">
                        <div class="box-body">
                            <span class="text-white icon-Shield-check fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Your Point</div>
                            <div class="text-white fs-24 fw-800">{{ Auth::user()->points ?? '0' }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="#" class="box box_color2">
                        <div class="box-body">
                            <span class="text-white mdi mdi-ticket-confirmation fs-30"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($total_task) }}</div>
                        </div>
                    </a>
                </div>
                <?php
                    $today_order_amount = 0;
                    $month_order_amount = 0;
                    $today_receive_amount = 0;
                    $month_receive_amount = 0;
                    $today_date = date('Y-m-d');
                    // $today_date = "2025-01-06";
                    $this_month = now()->month;
                    $today_project = \App\Models\Project::where('added_by', Auth::user()->id)->where('created_at', 'like', '%'.$today_date.'%')->get();
                    $month_project = \App\Models\Project::where('added_by', Auth::user()->id)->whereMonth('created_at', $this_month)->get();
                    // dd($month_project);
                    if ($today_project) {
                        foreach ($today_project as $key => $value) {
                            $today_order_amount += $value->bid_amount;
                            $today_bid = \App\Models\ProjectBitAmount::where('fld_project_id', $value->id)->get();
                            if ($today_bid) {
                                foreach ($today_bid as $key3 => $value3) {
                                    $today_receive_amount += $value3->fld_project_amount;
                                }
                            }
                        }
                    }
                    if ($month_project) {
                        $month_receive_amount = 0;
                        foreach ($month_project as $key1 => $value1) {
                            $month_order_amount += $value1->bid_amount;
                            $month_bid = \App\Models\ProjectBitAmount::where('fld_project_id', $value1->id)->get();
                            if ($month_bid) {
                                foreach ($month_bid as $key4 => $value4) {
                                    $month_receive_amount += $value4->fld_project_amount;
                                }
                            }
                        }
                    }
                ?>
                @if($month_receive_amount)
                <div class="col-lg-4 col-12">
                    
                    <a class="box box_color1">
                        <div class="box-body">
                            <div class="row">
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">Today Order Value ({{ date('d-m-Y') }})</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($today_order_amount, 2) }}
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">Received Amount</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($today_receive_amount, 2) }}
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">This Month Order Value</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($month_order_amount, 2) }}
                                </div>
                                <hr>
                                <div class="text-white fw-600 fs-14 col-md-6 col-6">This Month Received Amount</div>
                                <div class="text-white text-end fs-16 fw-800 col-md-6 col-6">
                                    {{ number_format($month_receive_amount, 2) }}
                                </div>
                            </div>
                        </div>
                    </a>
                    
                </div>
                @endif
                <?php
                    $total_incentive = 0;
                    $incentive_details = \App\Models\Incentive::where('user_id', Auth::user()->id)->get();
                    if (count($incentive_details) > 0) {
                        foreach ($incentive_details as $key => $value) {
                            $total_incentive += $value->amount;
                        }
                    }
                ?>
                @if($total_incentive)
                <div class="col-lg-2 col-12">
                    <a href="{{ route('staff.incentive') }}" class="box box_color4">
                        <div class="box-body">
                            <span class="text-white icon-Equalizer fs-40"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path3"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Incentive Amount</div>
                            <div class="text-white  fs-24 fw-800">{{ number_format($total_incentive, 2) }}</div>
                        </div>
                    </a>
                </div>
                @endif
            </div>
            <hr>
            <div class="row">
                {{-- <div class="col-lg-3 col-12">
                    <a href="#" class="box bg-success bg-hover-success">
                        <div class="box-body">
                            <span class="text-white icon-Equalizer fs-40"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path3"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Pending Task</div>
                            <div class="text-white  fs-24 fw-800">{{ count($pending) }}</div>
                        </div>
                    </a>
                </div> --}}
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.progress') }}" class="box box_color5">
                        <div class="box-body">
                            <span class="text-white icon-Smile fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Progress Task</div>
                            <div class="text-white  fs-24 fw-800">{{ count($progress) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.over_due') }}" class="box bg-danger bg-hover-danger">
                        <div class="box-body">
                            <span class="text-white mdi mdi-ticket-confirmation fs-30"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Over Due Task</div>
                            <div class="text-white  fs-24 fw-800">{{ count($over_due) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.completed') }}" class="box bg-info bg-hover-info">
                        <div class="box-body">
                            <span class="text-white icon-Chart-line fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Admin Review</div>
                            <div class="text-white  fs-24 fw-800">{{ count($admin_review) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.closed') }}" class="box bg-warning bg-hover-warning">
                        <div class="box-body">
                            <span class="text-white icon-Money fs-40"><span class="path1"></span><span class="path2"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Closed Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($completed) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.rejected') }}" class="box box_color4">
                        <div class="box-body">
                            <span class="text-white icon-Attachment1 fs-40"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Rejected Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($rejected) }}</div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-12">
                    <a href="{{ route('staff.recurring') }}" class="bg-hover-danger box box_color1">
                        <div class="box-body">
                            <span class="text-white mdi mdi-ticket-confirmation fs-30"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                            <div class="text-white fw-600 fs-18 mb-2">Total Recurring Task</div>
                            <div class="text-white fs-24 fw-800">{{ count($total_recurring) }}</div>
                        </div>
                    </a>
                </div>
                
            </div>

            
        </section>
        <!-- /.content -->
      </div>
</div>
@endsection
