@extends('layouts.front')
@section('title', '')
@section('description', '')
@section('keyword', '')

@section('og_content')

@endsection

@section('content')

	<section class="page-banner">
        <img src="<?php echo url('');?>/public/asstes/images/love-red.png" class="red-heart-vector" alt="">
        <div class="banner-content">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-11 col-md-8">
                        <h5 class="banner-title">Become A <span>Volunteer</span>
                        </h5>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('user.home') }}">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Become A Volunteer</li>
                            </ol>
                        </nav>

                    </div>

                </div>
            </div>
        </div>
    </section>



    <section class="volunteer-detail">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-6">
                    <h5 class="volunteer-title">Let’s join our community to become a volunteer</h5>
                    <div class="row gy-4">
                        <div class="col-md-6">
                            <div class="volunteer-img">
                                <img src="<?php echo url('');?>/public/asstes/images/blog-big-1.webp" alt="">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="volunteer-img">
                                <img src="<?php echo url('');?>/public/asstes/images/blog-big-2.webp" alt="">
                            </div>
                        </div>
                    </div>
                    <h5 class="volunteer-subtitle">Volunteer Requirements</h5>
                    <p class="volunteer-text">Discover the inspiring stories of individuals and communities transformed
                        by our programs. Our success stories highlight the real-life impact of your donations and the
                        resilience of those we help. These narratives showcase the power of compassion and generosity.
                    </p>
                    <ul class="volunteer-list">
                        <li>Making this first true generator simply text</li>
                        <li>Many desktop publish packages nothing</li>
                        <li>If you are going to passage</li>
                        <li>It has roots in a piece</li>
                        <li>Sed ut perspiciatis unde iste natus</li>
                    </ul>
                </div>
                <div class="col-lg-6">
                    @include('layouts.flash-message')
                    <div class="comment-box ">
                        <h5 class="box-title">Volunteer</h5>
                        <p class="box-text">To join with Yaan Foundation fill out the following form</p>
                        <form action="{{ route('user.volunteer.submit') }}" method="post" class="row gy-3 ">
                            @csrf
                            <div class="col-md-12">
                                <label class="form-label">Your Name</label>
                                <input type="text" class="form-control" id="exampleFormControlInput1" name="name" 
                                    placeholder="Enter Your Name" minlength="3" required>
                                @if ($errors->has('name'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="exampleFormControlInput1" name="email"
                                    placeholder="Enter Your Email Address" required>
                                @if ($errors->has('email'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Phone Number</label>
                                <input type="number" name="phone" class="form-control" minlength="10" maxlength="12"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    id="exampleFormControlInput1" placeholder="Enter Your Phone Number" required>
                                @if ($errors->has('phone'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Date Of Birth</label>
                                <input type="date" onfocus="'showPicker' in this && this.showPicker()" name="date_of_birth"
                                    class="form-control" id="exampleFormControlInput1" placeholder="Date Of Birth"
                                    required>
                                @if ($errors->has('date_of_birth'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date_of_birth') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Occupation</label>
                                <input type="text" class="form-control" id="exampleFormControlInput1" name="occupation"
                                    placeholder="Enter Occupation" required>
                                @if ($errors->has('occupation'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('occupation') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Write a Comment</label>
                                <input type="text" name="message" class="form-control" id="exampleFormControlInput1"
                                    placeholder="Enter Your Comment">
                                @if ($errors->has('message'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('message') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-3">
                                <div class="captcha">

                                  <span>{!! captcha_img() !!}</span>

                                    <button type="button" class="btn btn-success btn-refresh"><i class="fa fa-refresh"></i></button>

                                </div>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" id="exampleFormControlInput1" name="captcha"
                                    placeholder="Enter Captcha" required>
                                @if ($errors->has('captcha'))\
                                    <span class="help-block">
                                        <strong>{{ $errors->first('captcha') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault"
                                        required>
                                    <label class="form-check-label" for="flexCheckDefault">
                                        I agree the Yaan Foundation <a href="{{ route('user.terms.conditions') }}" class="text-link">Terms and
                                            conditions</a> &
                                        <a href="{{ route('user.privacy.policy') }}" class="text-link">Privacy Policy</a>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button class="btn submit-btn">Submit Now</button>
                                <!-- <a href="#" data-bs-toggle="modal" data-bs-target="#volunteerModal"
                                    class="btn submit-btn">Submit
                                    Now</a> -->
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <script type="text/javascript">


    $(".btn-refresh").click(function(){

      $.ajax({

         type:'GET',

         url:'{{ route('refresh_captcha') }}',

         success:function(data){

            $(".captcha span").html(data.captcha);

         }

      });

    });



    </script>
@endsection