@extends('layouts.front')
@section('title', 'Contact Us')
@section('description', 'Webbitech is a leading website design and development company in coimbatore with over a decade of experience in designing faster & high functionality websites.')
@section('keyword', '')
@section('og_content')

@endsection

@section('content')
    
    @if (Session::get('success'))
    <div class="modal fade scanner-modal volunteer-modal" id="contactModal" tabindex="-1"
        aria-labelledby="contactModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-body position-relative text-center">
                    
                    <dotlottie-player src="https://lottie.host/2af6b394-11c1-442f-bd14-c3ffd3451681/Tn1R5KoHxH.lottie"
                        background="transparent" speed="1" style="width: 300px; height: 300px; margin: 0 auto;" loop
                        class="lottie-animate" autoplay></dotlottie-player>
                        <h5 class="modal-title">Congratlations <span id="modalBody">{{ session('name') }}</span></h5>
                    <p class="modal-text">Your contact form successfuly submitted</p>
                </div>
            </div>
        </div>
    </div>
    @endif

    <script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    @if (Session::get('success'))
    <script>
        window.onload = function() {
            var name = "{{ session('name') }}";

            document.getElementById('modalBody').innerHTML = `${name}`;
            
            // Show the modal
            $('#contactModal').modal('show');
        };
        $("document").ready(function(){
              setTimeout(function(){
                $('#contactModal').modal('hide');
              }, 5000 ); 

        });
    </script>
    @endif

    <section class="page-banner">
        <img src="<?php echo url('');?>/public/asstes/images/love-red.png" class="red-heart-vector" alt="">
        <div class="banner-content">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-11 col-md-8">
                        <h5 class="banner-title">Contact <span>Us</span>
                        </h5>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('user.home') }}">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
                            </ol>
                        </nav>

                    </div>

                </div>
            </div>
        </div>
    </section>


    <section class="contact-detail">
        <div class="container">
            <div class="address-detail">
                <div class="row gy-4 align-items-center">
                    <div class="col-md-6 col-lg-5">
                        <div class="social-wrapper">
                            <ul class="social-address-list">
                                <li>
                                    <div class="icon">
                                        <img src="<?php echo url('');?>/public/asstes/images/location.svg" alt="">
                                    </div>
                                    <div class="text">
                                        <p class="contact-text">Locate Address</p>
                                        <a href="" class="phone-number">40A, Kannagi Street,Teachers Colony,
                                            <br>Dr.Radhakrishna Road,Erode – 638011.</a>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <img src="<?php echo url('');?>/public/asstes/images/call.svg" alt="">
                                    </div>
                                    <div class="text">
                                        <p class="contact-text">Call us any time:</p>
                                        <a href="+917373288844" class="phone-number">+91 737 328 8844</a>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <img src="<?php echo url('');?>/public/asstes/images/mail.svg" alt="">
                                    </div>
                                    <div class="text">
                                        <p class="contact-text">Email us any time:</p>
                                        <a href="mailto:yaan.live@gmail.com"
                                            class="phone-number">yaan.live@gmail.com</a>
                                    </div>
                                </li>
                            </ul>
                            <div class="social">
                                <ul class="mb-0 px-0">
                                    <li>
                                        <a href=""><img src="<?php echo url('');?>/public/asstes/images/facebook.svg" alt="facebook"></a>
                                    </li>
                                    <li>
                                        <a href=""><img src="<?php echo url('');?>/public/asstes/images/instagram.svg" alt="instagram"></a>
                                    </li>
                                    <li>
                                        <a href=""><img src="<?php echo url('');?>/public/asstes/images/youtube.svg" alt="youtube"></a>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-7">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m16!1m12!1m3!1d15647.978184191366!2d77.70094523415838!3d11.335108560890005!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!2m1!1s40A%2C%20Kannagi%20Street%2CTeachers%20Colony%2C%20Dr.Radhakrishna%20Road%2CErode%20%E2%80%93%20638011.!5e0!3m2!1sen!2sin!4v1733239125989!5m2!1sen!2sin"
                            width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
            <div class="mt-5">
                <div class="row gy-4 align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-7 order-1 order-lg-0">
                        <img src="<?php echo url('');?>/public/asstes/images/contact.png" width="100%" alt="">
                    </div>

                    <div class="col-lg-6 col-md-12 order-0 order-lg-1">
                        @include('layouts.flash-message')
                        <div class="form-box">
                            <form action="{{ route('user.contact.submit') }}" method="post" class="row gy-3 ">
                            @csrf
                                <div class="col-md-12">
                                    <label class="form-label">Your Name</label>
                                    <input type="text" class="form-control" name="name" id="exampleFormControlInput1"
                                        placeholder="Enter Your Name" required>
                                    @if ($errors->has('name'))\
                                        <span class="help-block">
                                            <strong>{{ $errors->first('name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">Email Address</label>
                                    <input type="email" class="form-control" name="email" id="exampleFormControlInput1"
                                        placeholder="Enter Your Email Address" required>
                                    @if ($errors->has('email'))\
                                        <span class="help-block">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">Phone Number</label>
                                    <input type="text" class="form-control" name="phone" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" id="exampleFormControlInput1"
                                        placeholder="Enter Your Phone Number" required>
                                    @if ($errors->has('phone'))\
                                        <span class="help-block">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class=" col-md-12">
                                    <label class="form-label">Write Message</label>
                                    <textarea class="form-control" name="message" id="exampleFormControlTextarea1"
                                        placeholder="Write Your Comments Here" rows="3"></textarea>
                                    @if ($errors->has('message'))\
                                        <span class="help-block">
                                            <strong>{{ $errors->first('message') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-3">
                                    <div class="captcha">

                                      <span>{!! captcha_img() !!}</span>

                                        <button type="button" class="btn btn-success btn-refresh"><i class="fa fa-refresh"></i></button>

                                    </div>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" class="form-control" name="captcha" id="exampleFormControlInput1"
                                        placeholder="Enter Captcha" required>
                                    @if ($errors->has('captcha'))\
                                        <span class="help-block">
                                            <strong>{{ $errors->first('captcha') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-12">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault" required>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            I agree the Yaan Foundation <a href="{{ route('user.terms.conditions') }}" class="text-link">Terms and
                                                conditions</a> &
                                            <a href="{{ route('user.privacy.policy') }}" class="text-link">Privacy Policy</a>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <button class="btn submit-btn">Submit Now</button>
                                    <!-- <a href="#" data-bs-toggle="modal" data-bs-target="#contactModal"
                                    class="btn submit-btn">Submit
                                    Now</a> -->
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <script type="text/javascript">


    $(".btn-refresh").click(function(){

      $.ajax({

         type:'GET',

         url:'{{ route('refresh_captcha') }}',

         success:function(data){

            $(".captcha span").html(data.captcha);

         }

      });

    });



    </script>
@endsection