@extends('layouts.front')
@section('title', $blog_details->m_title)
@section('description', $blog_details->description)
@section('keyword', $blog_details->keyword)
@section('og_content')

@endsection

@section('content')

<section class="common-wrapper pb-7 pt-7">
        <div class="container">
            <div class="common-heading text-center">
                <span>WEBBITECH</span>
                <h1>{{ $blog_details->name }}</h1>
            </div>
        </div>
    </section>
  

  <div class="common-color">
      <!--blog-section-start-->
  <section class="blog-wrapper common-padding">
    <div class="container-fluid common-spacing">
      <div class="row">
        <div class="col-lg-8">
          <div class="blog-details">
            <img class="img-fluid" src="{{ url('/') }}/public/banner_image/{{ $blog_details->image }}" alt="{{ $blog_details->name }}">
            {!! $blog_details->content !!}
          </div>
        </div>
        <div class="col-lg-4">
          <div class="search-wrapper">
            <div class="form-group has-search">
              <span class="fa fa-search form-control-feedback"></span>
              <input type="text" class="form-control" placeholder="Search">
            </div>
          </div>
          <div class="post-wrapper mt-4">
            <h4>Recent Post</h4>

            @if($recent_blog)
          	@foreach($recent_blog as $key1 => $value1)
          	<div class="post-recent d-flex align-items-center pt-4">
            	<div class="post-img">
                	<img src="{{ url('/') }}/public/banner_image/{{ $value1->image }}" alt="{{ $value1->name }}">
             	</div>
             	<div class="post-details pl-4">
                	<h3>{{ $value1->name }}</h3>
                	<div class="banner-button mt-1">
	                   <a href="{{ route('user.blog.details', $value1->url_slug) }}">Read More <img src="<?php echo url('');?>/public/asstes/images/blog/arrowblack.webp" alt="Webbitech Mastero Private Limited - Web Design And Development Company In Coimbatore">
	                   </a>
	                </div>
	            </div>
          </div>
          @endforeach
          @endif

          </div>
        </div>
      </div>
    </div>
  </section>
  <!--blog-section-end-->
  </div>

@endsection