@extends('layouts.front')
@section('title', '')
@section('description', '')
@section('keyword', '')

@section('og_content')

@endsection

@section('content')
    
    @if (Session::get('success'))
    <div class="modal fade scanner-modal" id="donateBox" tabindex="-1" aria-labelledby="donateBoxLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-body">
                    <p class="scan-text">Scan and Pay</p>
                    <div class="row gy-4 align-items-center">
                        <div class="col-md-12">

                            <div class="img-box text-center">
                                <img src="<?php echo url('');?>/public/asstes/images/qr.png" alt="">
                            </div>

                        </div>
                    </div>
                    <div class="upi-list">
                        <div class="row gy-4 align-items-center">
                            <div class="col-6">
                                <div class="upi-img">
                                    <img src="<?php echo url('');?>/public/asstes/images/paytm.png" alt="">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="upi-img">
                                    <img src="<?php echo url('');?>/public/asstes/images/gpay.png" alt="">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="upi-img">
                                    <img src="<?php echo url('');?>/public/asstes/images/phonepea.png" alt="">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="upi-img">
                                    <img src="<?php echo url('');?>/public/asstes/images/amazon-pay.png" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    @if (Session::get('success'))
    <script>
        window.onload = function() {
            // Show the modal
            $('#donateBox').modal('show');
        };
        // $("document").ready(function(){
        //       setTimeout(function(){
        //         $('#donateBox').modal('hide');
        //       }, 5000 ); 

        // });
    </script>
    @endif

	<section class="page-banner">
        <img src="<?php echo url('');?>/public/asstes/images/love-red.png" class="red-heart-vector" alt="">
        <div class="banner-content">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-11 col-md-8">
                        <h5 class="banner-title">Donate <span>Us</span>
                        </h5>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('user.home') }}">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Donate Us</li>
                            </ol>
                        </nav>

                    </div>

                </div>
            </div>
        </div>
    </section>


    <section class="donate-detail">
        <div class="container">

            <div class="row gy-4">
                <div class="col-lg-6">
                    <h5 class="donate-title">Small Action Lead To Big changes</h5>
                    <p class="donate-text">At Yaan Foundation, we envision a world where education is accessible, hunger
                        is eradicated, and our environment is free from the shackles of plastic pollution. By focusing
                        on these key pillars, we work tirelessly to pave the way for a sustainable, prosperous future
                        for generations to come.</p>
                    <div class="donation-wrapper">
                        <h6 class="donate-subtitle ">To Make Your Donation</h6>
                        <div class="donation-wrapper-inner mb-3">
                            <div class="row gy-4 align-items-center">
                                <div class="col-md-6">
                                    <div class="img-box text-center">
                                        <img src="<?php echo url('');?>/public/asstes/images/qr.png" alt="">
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <h5 class="wrapper-title">To Transfer to Account</h5>
                                    <div class="mt-3">
                                        <div class="row gy-3 align-items-center">
                                            <div class="col-md-12">
                                                <p class="wrapper-text">Bank Name</p>
                                                <h6 class="wrapper-subtitle">Karur Vysya Bank</h6>
                                            </div>
                                            <div class="col-md-12">
                                                <p class="wrapper-text">Account No</p>
                                                <h6 class="wrapper-subtitle">1863135000003632</h6>
                                            </div>
                                            <div class="col-md-12">
                                                <p class="wrapper-text">IFSC Code</p>
                                                <h6 class="wrapper-subtitle">KVBL0001863</h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="upi-list">
                                <div class="row gy-4 align-items-center">
                                    <div class="col-6 col-md-3">
                                        <div class="upi-img">
                                            <a href=""><img
                                                    src="<?php echo url('');?>/public/asstes/images/paytm.png" alt=""></a>
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <div class="upi-img">
                                            <img src="<?php echo url('');?>/public/asstes/images/gpay.png" alt="">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <div class="upi-img">
                                            <img src="<?php echo url('');?>/public/asstes/images/phonepea.png" alt="">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <div class="upi-img">
                                            <img src="<?php echo url('');?>/public/asstes/images/amazon-pay.png" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <p class="donate-text">Please find our PAN and registration numbers. Upon successful payments,
                            You will get a tax exemption certificate based on Indian government rules and regulations.
                            It will benefit from your yearly IT submissions.</p>
                        <div class="pan-detail mb-3">
                            <div class="row gy-4">
                                <div class="col-md-6">
                                    <ul class="social-address-list">
                                        <li>
                                            <div class="icon">
                                                <img src="<?php echo url('');?>/public/asstes/images/pan.svg" alt="">
                                            </div>
                                            <div class="text">
                                                <p class="contact-text">PAN Number</p>
                                                <a href="" class="phone-number">AAATY9969Q</a>
                                            </div>
                                        </li>


                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <ul class="social-address-list">
                                        <li>
                                            <div class="icon">
                                                <img src="<?php echo url('');?>/public/asstes/images/register.svg" alt="">
                                            </div>
                                            <div class="text">
                                                <p class="contact-text">Registration no</p>
                                                <a href="+917373288844" class="phone-number">AAATY9969QF20231</a>
                                            </div>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                        <p class="clarify-text">For any issues or clarifications email at</p>
                        <h6 class="clarify-title">yaan.live@gmail.com</h6>
                    </div>

                </div>
                <div class="col-lg-6">
                     @include('layouts.flash-message')
                    <div class="form-box ">
                        <h5 class="box-title">Donate</h5>
                        <p class="box-text">To join with Yaan Foundation fill out the following form</p>
                        <h6 class="box-subtitle mt-2">Personal Information</h6>
                        <form action="{{ route('user.donate.submit') }}" method="post" class="row gy-3 ">
                            @csrf
                            <div class="col-md-12">
                                <label class="form-label">Your Name</label>
                                <input type="text" name="name" class="form-control" id="exampleFormControlInput1"
                                    placeholder="Enter Your Name" required>
                                @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Mobile Number</label>
                                <input type="number" name="phone" class="form-control"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    id="exampleFormControlInput1" placeholder="Enter Your Mobile Number" required>
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email Address</label>
                                <input type="email" name="email" class="form-control" id="exampleFormControlInput1"
                                    placeholder="Enter Your Email Address" required>
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Address</label>
                                <input type="text" name="address" class="form-control" id="exampleFormControlInput1"
                                    placeholder="Enter Your Address" required>
                                @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">City</label>
                                <input type="text" name="city" class="form-control" id="exampleFormControlInput1"
                                    placeholder="Enter Your City" required>
                                @if ($errors->has('city'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('city') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Postcode/ Zip Code</label>
                                <input type="text" name="zipcode" class="form-control" minlength="2" maxlength="12"
                                    id="exampleFormControlInput1" placeholder="Enter Your Postcode/ Zip Code" required>
                                @if ($errors->has('zipcode'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('zipcode') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Donation Amount</label>
                                <input type="number" name="amount" class="form-control"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    id="exampleFormControlInput1" placeholder="Enter Donation Amount" required>
                                @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Message</label>
                                <input type="text" name="message" class="form-control" id="exampleFormControlInput1"
                                    placeholder="Enter Your Message">
                            </div>
                            <div class="col-md-3">
                            	<div class="captcha">

		                          <span>{!! captcha_img() !!}</span>

		                          	<button type="button" class="btn btn-success btn-refresh"><i class="fa fa-refresh"></i></button>

		                          </div>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" id="exampleFormControlInput1" name="captcha" 
                                    placeholder="Enter Captcha" required>
                                @if ($errors->has('captcha'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('captcha') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        I agree the Yaan Foundation <a href="{{ route('user.terms.conditions') }}" class="text-link">Terms and
                                            conditions</a> &
                                        <a href="{{ route('user.privacy.policy') }}" class="text-link">Privacy Policy</a>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button class="btn submit-btn">Submit Now</button>
                                <!-- <a href="" data-bs-toggle="modal" data-bs-target="#donateBox" class="btn submit-btn" id="play-button">Donate Now</a> -->
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </section>

<script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script type="text/javascript">


$(".btn-refresh").click(function(){

  $.ajax({

     type:'GET',

     url:'{{ route('refresh_captcha') }}',

     success:function(data){

        $(".captcha span").html(data.captcha);

     }

  });

});



</script>
@endsection