@extends('layouts.dashboard')

@section('content')

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
	  <div class="container-full">
		<!-- Content Header (Page header) -->	  
		<div class="content-header">
			<div class="d-flex align-items-center">
				<div class="me-auto">
					<h3 class="page-title">Profile</h3>
					<div class="d-inline-block align-items-center">
						<nav>
							<ol class="breadcrumb">
								<li class="breadcrumb-item"><a href="{{ route('admin.index') }}"><i class="mdi mdi-home-outline"></i></a></li>
								<li class="breadcrumb-item" aria-current="page">Extra</li>
								<li class="breadcrumb-item active" aria-current="page">Profile</li>
							</ol>
						</nav>
					</div>
				</div>
				
			</div>
		</div>

		<!-- Main content -->
		<section class="content">

		  <div class="row">
			<div class="col-12 col-lg-7 col-xl-8">

				<div class="nav-tabs-custom">
					<ul class="nav nav-tabs">
					  <li><a class="active" href="#usertimeline" data-bs-toggle="tab">Profile Update</a></li>
					  <!-- <li><a href="#activity" data-bs-toggle="tab">Incentive Amount List</a></li> -->
					</ul>

					<div class="tab-content">

				  	<div class="active tab-pane" id="usertimeline">
				  		<div class="box">
	                @include('layouts.flash-message')
	                @if ($errors->any())
	                    <div class="alert alert-danger">
	                        <strong>Whoops!</strong> There were some problems with your input.<br><br>
	                        <ul>
	                            @foreach ($errors->all() as $error)
	                                <li>{{ $error }}</li>
	                            @endforeach
	                        </ul>
	                    </div>
	                @endif
	                <!-- /.box-header -->
	                <div class="box-body">
	                	<div class="box no-shadow">		
											<form class="form-horizontal form-element col-12" action="{{ route('admin.profile.upload', $user->id) }}" method="post" enctype="multipart/form-data">
												@csrf

												  <div class="form-group row">
													<label for="inputName" class="col-sm-2 form-label">Name</label>

													<div class="col-sm-10">
													  <input type="text" class="form-control" id="inputName" name="name" placeholder="" value="{{ $user->name }}">
													</div>
												  </div>

												  <div class="form-group row">
													<label for="inputEmail" class="col-sm-2 form-label">Website Logo</label>

													<div class="col-sm-10">
													  <input type="file" class="form-control" id="inputEmail" name="profile_picture" placeholder="">
													</div>
												  </div>
												  
												  <div class="form-group row">
													<label for="inputSkills" class="col-sm-2 form-label">Meta Title</label>

													<div class="col-sm-10">
													  <input type="text" class="form-control" id="inputSkills" name="meta_ttle" placeholder="Meta Title" value="{{ $user->meta_ttle }}">
													</div>
												  </div>
												  
												  <div class="form-group row">
													<label for="inputSkills" class="col-sm-2 form-label">Meta Description</label>

													<div class="col-sm-10">
													  <input type="text" class="form-control" id="inputSkills" name="meta_description" placeholder="Meta Description" value="{{ $user->meta_description }}">
													</div>
												  </div>

												  <div class="form-group row">
													<label for="inputSkills" class="col-sm-2 form-label">Meta Keyword</label>

													<div class="col-sm-10">
													  <input type="text" class="form-control" id="inputSkills" name="meta_keyword" placeholder="Meta Keyword" value="{{ $user->meta_keyword }}">
													</div>
												  </div>
												  
												  <div class="form-group row">
													<label for="inputSkills" class="col-sm-2 form-label">Password</label>

													<div class="col-sm-10">
													  <input type="password" class="form-control" id="inputSkills" name="password" placeholder="">
													</div>
												  </div>

												  <div class="form-group row">
													<label for="inputSkills" class="col-sm-2 form-label">Confirm Password</label>

													<div class="col-sm-10">
													  <input type="password" class="form-control" id="inputSkills" name="password_confirmation" placeholder="">
													</div>
												  </div>
												  
												  <div class="form-group row">
													<div class="col-sm-10">
														<input type="submit" name="submit" class="btn btn-primary" value="Submit">
													  <!-- <button type="submit" class="btn btn-success">Submit</button> -->
													</div>
												  </div>
												</form>
											</div>
										</div>
	                </div>
				  	</div>
				  	<div class="tab-pane" id="activity">
				  		
				  	
				  	</div>
				  </div>

				</div>

				
	    </div>
				
			  
			<!-- /.col -->		

			  <div class="col-12 col-lg-5 col-xl-4">
				 <div class="box box-widget widget-user">
					<!-- Add the bg color to the header using any of the bg-* classes -->
					<div class="widget-user-header bg-img bbsr-0 bber-0" style="background: url('../admin/images/gallery/full/10.jpg') center center;" data-overlay="5">
					  <h3 class="widget-user-username text-white">{{ $user->name }}</h3>
					  <!-- <h6 class="widget-user-desc text-white">Designer</h6> -->
					</div>
					<div class="widget-user-image">
					@if($user->profile_picture)
					  <img class="rounded-circle" src="<?php echo url('');?>/public/profile/{{$user->profile_picture}}" alt="User Avatar">
					@else
					<img class="rounded-circle" src="<?php echo url('');?>/public/admin/images/user3-128x128.jpg" alt="User Avatar">
					@endif
					</div>
					{{-- <div class="box-footer">
					  <div class="row">
						<div class="col-sm-4">
						  <div class="description-block">
							<h5 class="description-header">{{ count($total_sub) }}</h5>
							<span class="description-text">Total Sub Admin</span>
						  </div>
						  <!-- /.description-block -->
						</div>
						<!-- /.col -->
						<div class="col-sm-4 be-1 bs-1">
						  <div class="description-block">
							<h5 class="description-header">{{ count($total_staff) }}</h5>
							<span class="description-text">Total Staff</span>
						  </div>
						  <!-- /.description-block -->
						</div>
						<!-- /.col -->
						<div class="col-sm-4">
						  <div class="description-block">
							<h5 class="description-header">{{ count($total_task) }}</h5>
							<span class="description-text">Total Task</span>
						  </div>
						  <!-- /.description-block -->
						</div>
						<!-- /.col -->
					  </div>
					  <!-- /.row -->
					</div> --}}
				  </div>
				  <div class="box">
					<div class="box-body box-profile">            
					  <div class="row">
						<div class="col-12">
							<div>
								<p>Email :<span class="text-gray ps-10">{{ $user->email }}</span> </p>
								<p>Phone :<span class="text-gray ps-10">{{ $user->phone }}</span></p>
								<p>Address :<span class="text-gray ps-10">{{ $user->address }} @if($user->city), @endif {{ $user->city }}@if($user->state), @endif {{ $user->state }} @if($user->country), @endif {{ $user->country }} @if($user->zip_code) - @endif {{ $user->zip_code }}</span></p>
							</div>
						</div>
					  </div>
					</div>
					<!-- /.box-body -->
				  </div>

			  </div>

		  </div>
		  <!-- /.row -->

		</section>
		<!-- /.content -->
	  </div>
  </div>
  <!-- /.content-wrapper -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script src="<?php echo url('');?>/public/admin_assets/js/vendors.min.js"></script>

@endsection