@extends('layouts.dashboard')

@section('content')

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
	  <div class="container-full">
		<!-- Content Header (Page header) -->
		<div class="content-header">
			<div class="d-flex align-items-center">
				<div class="me-auto">
					<h3 class="page-title">Create Pages</h3>
					<div class="d-inline-block align-items-center">
						<nav>
							<ol class="breadcrumb">
								<li class="breadcrumb-item"><a href="#"><i class="mdi mdi-home-outline"></i></a></li>
								<li class="breadcrumb-item" aria-current="page">Pages</li>
								<li class="breadcrumb-item active" aria-current="page">Create</li>
							</ol>
						</nav>
					</div>
				</div>
				
			</div>
		</div>	  
		<style type="text/css">
			[type="radio"]:not(:checked), [type="radio"]:checked {
			    position: relative;
			    left: -4px;
			    opacity: 1;
			}
			.cke_contents
			{
				height: 130px !important;
			}
		</style>
		<!-- Main content -->
		<section class="content">
			<div class="row">			  
				
				<div class="col-lg-12 col-12">
					
					@if ($errors->any())
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
					  <div class="box">
						<!-- /.box-header -->
						<form class="form" action="{{ route('admin.pages.store') }}" method="post" enctype="multipart/form-data">
							@csrf
							<div class="box-body">
								<div class="row">
									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Select Category</label>
											<div class="input-group mb-3">
												<select class="form-control select2 @error('category_id') is-invalid @enderror" name="category_id" id="category_id">
												    <option value="">Select Category</option>
													@if($PageCategory)
													@foreach($PageCategory as $key => $value)
													<option value="{{ $value->id }}">{{ $value->name }}</option>
													@endforeach
													@endif
												</select>
											</div>
											@error('category_id')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>
									
									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Name</label>
											<div class="input-group mb-3">
												<input type="text" class="form-control @error('name') is-invalid @enderror" name="name" placeholder="Name" id="name" value="{{ old('name') }}" onkeyup="CatogeryUrl()" required>
											</div>
											@error('name')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>
									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Image</label>
											<div class="input-group mb-3">
												<input type="file" class="form-control @error('product_image') is-invalid @enderror" name="product_image" placeholder="product_image" value="{{ old('product_image') }}">
											</div>
											@error('product_image')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>
									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">URL Slug</label>
											<div class="input-group mb-3">
												<input type="text" class="form-control @error('url_slug') is-invalid @enderror" name="url_slug" id="url_slug" placeholder="URL Slug" value="{{ old('url_slug') }}" required>
											</div>
											@error('url_slug')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>
									
									<div class="col-md-12">
										<h4 class="text-success">Page Section</h4>
    									<div class="col-12 text-center" id="dynamicTable">
    					                    <div class="row mb-3">
    					                        <div class="col-md-6">
    					                            <div class="row">
    					                                <div class="col-md-6" style="margin-bottom: 10px;">
            					                            <input type="text" name="addmore[0][name]" class="form-control"  placeholder="Title">
            					                        </div>
            					                        <div class="col-md-6" style="margin-bottom: 10px;">
            					                            <input type="text" name="addmore[0][sub_title]" class="form-control"  placeholder="Sub Title">
            					                        </div>
            					                        <div class="col-md-6" style="margin-bottom: 10px;">
            					                        	<div class="row">
            					                        		<label for="image" class="form-label text-start">Image Align</label><br>
            					                        		<div class="col-md-6 text-start">
            					                        			<input type="radio" name="addmore[0][image_side]" value="left">Left
            					                        		</div>
            					                        		<div class="col-md-6 text-start">
            					                        			<input type="radio" name="addmore[0][image_side]" value="right">Right
            					                        		</div>
            					                        	</div>
					                                    </div>
            					                        <div class="col-md-6" style="margin-bottom: 10px;">
            					                        	<div class="form-group text-start">
	            					                            <label class="form-label text-start">Image</label>
	            					                            <input type="file" name="addmore[0][t_image]" class="form-control"  placeholder="Price" multiple>
	            					                        </div>
            					                        </div>
    					                            </div>
    					                        </div>
    					                        <div class="col-md-5">
            										<div class="form-group">
            											<textarea name="addmore[0][description]" id="editor1" class="form-control" rows="10"></textarea>
            										</div>
            									</div>
    					                        <div class="col-md-1"><a href="javascript::void(0)" name="add" id="add" title="Add More"><i class="btn btn-success mdi mdi-plus"></i></a></div>
    					                        
    					                    </div>
    					                </div>
					                </div>
									
									<!-- <div class="col-md-12">
										<div class="form-group">
											<label class="form-label">Description</label>
											<textarea id="editor1" name="editor1" rows="10" cols="80">
													
											</textarea>
										</div>
									</div> -->

									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Meta Title</label>
											<div class="input-group mb-3">
												<input type="text" class="form-control @error('meta_title') is-invalid @enderror" name="meta_title" placeholder="Meta Title" value="{{ old('meta_title') }}" required>
											</div>
											@error('meta_title')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>

									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Meta Description</label>
											<div class="input-group mb-3">
												<input type="text" class="form-control @error('meta_description') is-invalid @enderror" name="meta_description" placeholder="Meta Description" value="{{ old('meta_description') }}" required>
											</div>
											@error('meta_description')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>

									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Meta Keyword</label>
											<div class="input-group mb-3">
												<input type="text" class="form-control @error('meta_keyword') is-invalid @enderror" name="meta_keyword" placeholder="Meta Keyword" value="{{ old('meta_keyword') }}" required>
											</div>
											@error('meta_keyword')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>
									
									<div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Status</label>
											<div class="input-group mb-3">
												<select class="form-control @error('status') is-invalid @enderror" name="status">
													<option value="Active">Active</option>
													<option value="In Active">In Active</option>
												</select>
											</div>
											@error('status')
			                                    <span class="invalid-feedback" role="alert">
			                                        <strong>{{ $message }}</strong>
			                                    </span>
			                                @enderror
										</div>
									</div>
								</div>
								
							</div>
							<!-- /.box-body -->
							<div class="box-footer text-end">
								<input type="submit" name="submit" class="btn btn-primary" value="Submit">
								<!-- <button type="submit" class="btn btn-primary">
								  <i class="ti-save-alt"></i> Save
								</button> -->
							</div>  
						</form>
					  </div>
					  <!-- /.box -->			
				</div>

		    </div>
			
		  </div>
		  <!-- /.row -->

		</section>
		<!-- /.content -->
	  </div>
  </div>
  <!-- /.content-wrapper -->
  	<style>
	    .note-editor .card-header {
	        display: block;
	    }
	</style>
    <script src="<?php echo url('');?>/public/admin_assets/js/vendors.min.js"></script>

    <script type="text/javascript">
        var i = 2;
        $("#add").click(function(){
            ++i;
            $("#dynamicTable").append('<div class="row dynamicrow mb-3">\
                    <div class="col-md-6">\
                        <div class="row">\
                            <div class="col-md-6" style="margin-bottom: 10px;">\
	                            <input type="text" name="addmore['+i+'][name]" class="form-control"  placeholder="Title">\
	                        </div>\
	                        <div class="col-md-6" style="margin-bottom: 10px;">\
	                            <input type="text" name="addmore['+i+'][sub_title]" class="form-control"  placeholder="Sub Title">\
	                        </div>\
	                        <div class="col-md-6" style="margin-bottom: 10px;">\
                                <div class="row">\
	                        		<label for="image" class="form-label text-start">Image Align</label><br>\
	                        		<div class="col-md-6 text-start">\
	                        			<input type="radio" name="addmore['+i+'][image_side]" value="left">Left\
	                        		</div>\
	                        		<div class="col-md-6 text-start">\
	                        			<input type="radio" name="addmore['+i+'][image_side]" value="right">Right\
	                        		</div>\
	                        	</div>\
                            </div>\
	                        <div class="col-md-6" style="margin-bottom: 10px;">\
	                        	<div class="form-group text-start">\
		                            <label class="form-label text-start">Image</label>\
		                            <input type="file" name="addmore['+i+'][t_image]" class="form-control"  placeholder="Price">\
		                        </div>\
	                        </div>\
                        </div>\
                    </div>\
                    <div class="col-md-5">\
						<div class="form-group">\
							<textarea name="addmore['+i+'][description]" id="editor'+i+'" class="form-control" rows="10"></textarea>\
						</div>\
					</div>\
                    <div class="col-md-1"><a href="javascript::void(0)" class="remove-tr" title="Remove"><i class="btn btn-danger mdi mdi-close"></i></a></div>\
                </div>\
                <script>\
                CKEDITOR.replace("editor'+i+'")'
		    );
        });
        $(document).on('click', '.remove-tr', function(){  
            $(this).parents('.dynamicrow').remove();
        });
        
        function CatogeryUrl()
		{
		    
		    var text = $("#name").val();
		    var fixed = text.toLowerCase();
		    var fixed1 = fixed.replace(/\s+/g, '-');
		    
		    $("#url_slug").val(fixed1);
		}

    </script>
@endsection