<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Carbon\Carbon;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function sub_admin()
    {
        return $this->hasOne(User::class,'id','sub_admin_id');
    }

    public function admin_details()
    {
        return $this->hasOne(User::class,'id','admin_id');
    }

    public function task_comments()
    {
        return $this->hasMany(TaskComment::class,'id','staff_id');
    }
    
    public function task_follow_comments()
    {
        return $this->hasMany(TaskFollowComment::class,'id','follower_id');
    }

}
