<?php

namespace App\Http\Controllers;

use App\Models\PageCategory;
use Illuminate\Http\Request;

class PageCategoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function view()
    {
        $client_details = PageCategory::get();
        return view('admin.branches', compact('client_details'));
    }

    public function store(Request $request)
    {
        // dd($request->all());
        if ($request->conference_id) {
            $pages       = PageCategory::find($request->conference_id);
        }
        else
        {
            $pages       = new PageCategory();
        }
        $pages->name     = $request->name;
        $pages->slug     = $request->slug;
        $pages->status   = $request->fld_status;

        if ($pages->save()) {
            if ($request->conference_id) {
                return redirect()->back()->with('warning', 'Category Updated Successfully');
            }
            return redirect()->back()->with('success', 'Category Added Successfully');
        }
        else
        {
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }

    public function edit(Request $request)
    {

        $pages                      = PageCategory::find($request->id);
        $data['name']               = $pages->name;
        $data['slug']               = $pages->slug;
        $data['fld_status']         = $pages->status;
        $data['conference_id']      = $request->id;

        return $data;
    }

    public function delete($id)
    {
        $pages                  = PageCategory::find($id);
        if ($pages->delete()) {
            return redirect()->back()->with('error', 'Category Deleted Successfully');
        }
        else
        {
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }

}
