<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Blog;
use App\Models\Career;
use App\Models\Contact;
use App\Models\Volunter;
use App\Models\Transaction;
use App\Models\Donation;
use Illuminate\Http\Request;
use Auth;
use Mail;

class IndexController extends Controller
{

    public function index()
    {

        \Artisan::call('cache:clear');
        \Artisan::call('config:clear');
        \Artisan::call('route:clear');
        \Artisan::call('view:clear');
        // \Artisan::call('schedule:run');

        $blog_details = Blog::latest()->limit(10)->get();
        
        return view('frontend.index', compact('blog_details'));
    }

    public function AboutUs()
    {
        return view('frontend.about-us');
    }

    public function volunteer()
    {
        return view('frontend.volunteer');
    }

    public function PrivacyPolicy()
    {
        return view('frontend.PrivacyPolicy');
    }

    public function TermsConditions()
    {
        return view('frontend.TermsConditions');
    }

    public function contact()
    {
        return view('frontend.contact');
    }

    public function RefundPolicy()
    {
        return view('frontend.RefundPolicy');
    }

    public function ErrorPage()
    {
        return view('frontend.ErrorPage');
    }

    public function DonateFoundation()
    {
        return view('frontend.DonateFoundation');
    }

    public function refreshCaptcha()
    {
        return response()->json(['captcha'=> captcha_img()]);
    }

    public function Blog()
    {
        $blog_details = Blog::where('status', 'Active')->latest()->get();
        $recent_blog = Blog::where('status', 'Active')->limit(5)->latest()->get();
        return view('frontend.blog', compact('blog_details', 'recent_blog'));
    }

    public function BlogDetails($slug)
    {
        $blog_details = Blog::where('url_slug', $slug)->first();
        $recent_blog = Blog::where('status', 'Active')->limit(5)->latest()->get();
        return view('frontend.blog_details', compact('blog_details', 'recent_blog'));
    }

    public function ContactSubmit(Request $request)
    {
        // dd($request->all());

        request()->validate([

            'email' => 'required|email',
            'name' => 'required',
            'phone' => 'required',
            'captcha' => 'required|captcha'

        ],
        
        ['captcha.captcha'=>'Invalid captcha code.']);

        $contact_details = new Contact();
        $contact_details->contact_id = $request->captcha;
        $contact_details->first_name = $request->name;
        $contact_details->last_name = $request->last_name ?? '';
        $contact_details->email = $request->email;
        $contact_details->phone = $request->phone;
        $contact_details->message = $request->message;
        $contact_details->status = 1;
        $contact_details->etc = "";

        
        if ($contact_details->save()) {
            return redirect()->route('user.contact')->with([
                'success' => 'Form submitted successfully!',
                'name' => $contact_details->first_name
            ]);
            // return redirect()->route('user.contact')->with('success', 'Contact Form Successfully', 'name' => $contact_details->first_name);
        }
        else{
            return redirect()->back()->with('error', 'Something Wrong');
        }

    }

    public function VolunteerSubmit(Request $request)
    {
        // dd($request->all());

        request()->validate([

            'email' => 'required|email',
            'name' => 'required',
            'phone' => 'required',
            'captcha' => 'required|captcha'

        ],
        
        ['captcha.captcha'=>'Invalid captcha code.']);

        $contact_details = new Volunter();

        $contact_details->volunteer_id = $request->captcha;
        $contact_details->name = $request->name;
        $contact_details->email = $request->email;
        $contact_details->dob = $request->date_of_birth;
        $contact_details->occupation = $request->occupation;
        $contact_details->comment = $request->message;
        $contact_details->status = 0;
        $contact_details->is_deleted = 0;
        $contact_details->etc = "";

        if ($contact_details->save()) {
            return redirect()->route('user.volunteer')->with([
                'success' => 'Volunter Form submitted successfully!',
                'name' => $contact_details->name
            ]);
        }
        else{
            return redirect()->back()->with('error', 'Something Wrong');
        }

    }

    public function DonateSubmit(Request $request)
    {
        // dd($request->all());

        request()->validate([

            'email' => 'required|email',
            'name' => 'required',
            'phone' => 'required'

        ]);

        $contact_details = new Transaction();

        $contact_details->transaction_id = $request->captcha;
        $contact_details->amount = $request->amount;
        $contact_details->pg_response = "{}";
        $contact_details->transaction_status = 0;
        $contact_details->etc = "";

        if ($contact_details->save()) {


            $data['personal_info'] = array(
                'first_name' => $request->name ,
                'email' =>  $request->email,
                'phone' =>  $request->phone,
                'address' =>  $request->address,
                'city' =>  $request->city,
                'pincode' =>  $request->zipcode,
            );

            $data['donation_info'] = array(
                'amount' => $request->amount,
                'remark' => $request->message,
            );

            $contact1 = new Donation();

            $contact1->donation_id = $request->captcha;
            $contact1->transaction_id = $contact_details->id;
            $contact1->personal_info = json_encode($data['personal_info']);
            $contact1->donation_info = json_encode($data['donation_info']);
            $contact1->etc = "";
            $contact1->status = 1;
            $contact1->is_deleted = 0;
            $contact1->etc = "";
            $contact1->save();

            return redirect()->route('user.donate.foundation')->with([
                'success' => 'Donate Form submitted successfully!',
                'name' => $contact_details->amount
            ]);
        }
        else{
            return redirect()->back()->with('error', 'Something Wrong');
        }

    }


    public function UserLogin(Request $request)
    {
        // dd($request->all());
        $field = 'email';

        // $request->merge([$field => $request->input('login')]);

        if (Auth::attempt($request->only($field, 'password'))) {
            // dd(Auth::user()->user_type);
            if (Auth::check() && Auth::user()->user_type == 'super_admin') {
                return redirect()->route('admin.index')->with('success', 'Login Successfully');
                // return redirect('/admin');
            }
            elseif (Auth::check() && Auth::user()->user_type == 'admin') {
                return redirect()->route('two.admin.index')->with('success', 'Login Successfully');
                // return redirect('/admin');
            }
            elseif (Auth::check() && Auth::user()->user_type == 'sub_admin') {
                return redirect()->route('sub.admin.index')->with('success', 'Login Successfully');
            }
            elseif (Auth::check() && Auth::user()->user_type == 'staff') {
                return redirect()->route('staff.index')->with('success', 'Login Successfully');
            }
        }

        return redirect()->back()->with('error', 'These credentials do not match our records.');
    }
}
