<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\Task;
use App\Models\TaskDetails;
use App\Exports\ExportTask;
use App\Models\Notification;
use App\Models\Incentive;
use App\Models\IncentiveAmount;
use App\Exports\ExportRecurringTask;
use Auth;
use Mail;
use PDF;
use File;
use Excel;
use DB;
use Netflie\WhatsAppCloudApi\WhatsAppCloudApi;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function admin_index()
    {
        
        return view('home');
    }
    
    public function two_admin_index()
    {
        return view('admin');
    }

    public function sub_admin_index()
    {
        return view('sub_admin');
    }

    public function staff_index()
    {
        return view('staff');
    }


    public function AdminProfile()
    {
        $user = User::where('id', Auth::user()->id)->first();
        return view('admin.profile', compact('user'));

    }

    public function AdminProfileUpload(Request $request, $id)
    {
        // dd($request->all());

        $user               = User::find($id);
        if ($request->password) {
            $request->validate([
                'name' => 'required|max:255',
                'password' => 'required|confirmed'
            ]);

            $password           = Hash::make($request->password);
            $user->password     = $password;
        }
        else
        {
            $request->validate([
                'name' => 'required|max:255'
            ]);
        }

        if ($request->hasFile('profile_picture')) {
            $image = $request->file('profile_picture');
            $filename = time().'.'.$image->extension();
            $destinationPath = public_path('/profile');
            // dd($destinationPath);
            $image->move($destinationPath, $filename);
            $user->profile_picture = $filename;
        }

        $user->name                = $request->name;
        $user->meta_ttle           = $request->meta_ttle;
        $user->meta_description    = $request->meta_description;
        $user->meta_keyword        = $request->meta_keyword;
        if ($user->save()) {
            return redirect()->route('admin.profile')->with('warning', 'Profile Edited Successfully');
        }
        else{
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }

}
