<?php

namespace App\Http\Controllers;

use App\Models\DynamicPage;
use App\Models\PageCategory;
use App\Models\PageDetails;
use Illuminate\Http\Request;

class DynamicPageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function view()
    {
        $dynamic_pages = DynamicPage::latest()->get();
        return view('admin.pages.view', compact('dynamic_pages'));
    }

    public function create()
    {
        $PageCategory = PageCategory::where('status', 'Active')->get();
        return view('admin.pages.add', compact('PageCategory'));
    }

    public function edit($id)
    {
        $dynamic_pages = DynamicPage::where('id', $id)->first();
        $PageCategory = PageCategory::where('status', 'Active')->get();
        return view('admin.pages.edit', compact('dynamic_pages', 'PageCategory'));
    }

    public function delete($id)
    {
        $pages                  = DynamicPage::find($id);
        if ($pages->delete()) {
            return redirect()->back()->with('error', 'Page Deleted Successfully');
        }
        else
        {
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }

    public function store(Request $request)
    {
        // dd($request->all());

        $image1 = $request->product_image;
        $banner_image1 = time().'banner.'.$image1->extension();  
        $image1->move(public_path('banner_image'), $banner_image1);

        $pages                = new DynamicPage();
        $pages->category_id   = $request->category_id;
        $pages->name          = $request->name;
        $pages->url_slug      = $request->url_slug;
        $pages->m_title       = $request->meta_title;
        $pages->description   = $request->meta_description;
        $pages->keyword       = $request->meta_keyword;
        $pages->thum_image    = $banner_image1;
        $pages->status        = $request->status;
        
        if ($pages->save()) {
            
            
            if (isset($request->addmore) && $request->addmore) {
                foreach ($request->addmore as $key => $value) {
                    // dd($value);
                    if (isset($value['t_image']) && $value['t_image']) {
                        $imageName1 = time().$key.'.'.$value['t_image']->extension();  
                
                        $value['t_image']->move(public_path('t_image'), $imageName1);
                    } else {
                        $imageName1 = $value['old_image'] ?? '';
                    }

                    $save_new_table                 = new PageDetails();
                    $save_new_table->page_id        = $pages->id;
                    $save_new_table->image          = $imageName1;
                    $save_new_table->subtile1       = $value['name'];
                    $save_new_table->subtile2       = $value['sub_title'];
                    $save_new_table->image_side     = $value['image_side'] ?? "left";
                    $save_new_table->content        = $value['description'];
                    $save_new_table->section_order  = $value['content_position'] ?? '';
                    $save_new_table->save();
                }
                
                // $pages['content']        = json_encode($store_dynamic_data);
            }

            return redirect()->route('admin.pages.view')->with('success', 'Pages Added Successfully');
        }
        return redirect()->back();

    }


    public function update(Request $request, $id)
    {

        $image1 = $request->product_image;
        if ($image1) {
            $banner_image1 = time().'banner.'.$image1->extension();  
            $image1->move(public_path('banner_image'), $banner_image1);
        }
        else
        {
            $banner_image1 = $request->old_banner_image;
        }

        $pages                = DynamicPage::find($id);
        $pages->category_id   = $request->category_id;
        $pages->name          = $request->name;
        $pages->url_slug      = $request->url_slug;
        $pages->m_title       = $request->meta_title;
        $pages->description   = $request->meta_description;
        $pages->keyword       = $request->meta_keyword;
        $pages->thum_image    = $banner_image1;
        $pages->status        = $request->status;
        
        if ($pages->save()) {
            
            PageDetails::Where('page_id',$id)->forceDelete(); 
            
            if (isset($request->addmore) && $request->addmore) {
                foreach ($request->addmore as $key => $value) {
                    // dd($value);
                    if (isset($value['t_image']) && $value['t_image']) {
                        $imageName1 = time().$key.'.'.$value['t_image']->extension();  
                
                        $value['t_image']->move(public_path('t_image'), $imageName1);
                    } else {
                        $imageName1 = $value['old_image'] ?? '';
                    }

                    $save_new_table                 = new PageDetails();
                    $save_new_table->page_id        = $pages->id;
                    $save_new_table->image          = $imageName1;
                    $save_new_table->subtile1       = $value['name'];
                    $save_new_table->subtile2       = $value['sub_title'];
                    $save_new_table->image_side     = $value['image_side'] ?? "left";
                    $save_new_table->content        = $value['description'];
                    $save_new_table->section_order  = $value['content_position'] ?? '';
                    $save_new_table->save();
                }
                
                // $pages['content']        = json_encode($store_dynamic_data);
            }

            return redirect()->route('admin.pages.view')->with('success', 'Pages Added Successfully');
        }
        return redirect()->back();
    }
}
