<?php

namespace App\Http\Controllers;

use App\Models\Career;
use Illuminate\Http\Request;

class CareerController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function view()
    {
        $client_details = Career::latest()->get();
        return view('admin.careers', compact('client_details'));
    }

    public function store(Request $request)
    {
        // dd($request->all());
        if ($request->conference_id) {
            $pages          = Career::find($request->conference_id);
        }
        else
        {
            $pages          = new Career();
        }
        $pages->name        = $request->name;
        $pages->salary      = $request->salary;
        $pages->experience  = $request->experience;
        $pages->location    = $request->location;
        $pages->job_type    = $request->job_type;
        $pages->time_type   = $request->time_type;
        $pages->status      = $request->fld_status;

        if ($pages->save()) {
            if ($request->conference_id) {
                return redirect()->back()->with('warning', 'Career Updated Successfully');
            }
            return redirect()->back()->with('success', 'Career Added Successfully');
        }
        else
        {
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }

    public function edit(Request $request)
    {

        $pages                      = Career::find($request->id);
        $data['name']               = $pages->name;
        $data['salary']             = $pages->salary;
        $data['experience']         = $pages->experience;
        $data['location']           = $pages->location;
        $data['job_type']           = $pages->job_type;
        $data['time_type']          = $pages->time_type;
        $data['fld_status']         = $pages->status;
        $data['conference_id']      = $request->id;

        return $data;
    }

    public function delete($id)
    {
        $pages                  = Career::find($id);
        if ($pages->delete()) {
            return redirect()->back()->with('error', 'Career Deleted Successfully');
        }
        else
        {
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }
}
