<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function view()
    {
        $dynamic_pages = Blog::latest()->get();
        return view('admin.blog.view', compact('dynamic_pages'));
    }

    public function create()
    {
        return view('admin.blog.add');
    }

    public function edit($id)
    {
        $dynamic_pages = Blog::where('id', $id)->first();
        return view('admin.blog.edit', compact('dynamic_pages'));
    }

    public function delete($id)
    {
        $pages                  = Blog::find($id);
        if ($pages->delete()) {
            return redirect()->back()->with('error', 'Blog Deleted Successfully');
        }
        else
        {
            return redirect()->back()->with('error', 'Something Wrong');
        }
    }

    public function store(Request $request)
    {
        // dd($request->all());

        $image1 = $request->product_image;
        $banner_image1 = time().'banner.'.$image1->extension();  
        $image1->move(public_path('banner_image'), $banner_image1);

        $pages                = new Blog();
        $pages->name          = $request->name;
        $pages->url_slug      = $request->url_slug;
        $pages->content       = $request->description;
        $pages->m_title       = $request->meta_title;
        $pages->description   = $request->meta_description;
        $pages->keyword       = $request->meta_keyword;
        $pages->image         = $banner_image1;
        $pages->status        = $request->status;
        
        if ($pages->save()) {

            return redirect()->route('admin.blog.view')->with('success', 'Blog Added Successfully');

        }
        return redirect()->back();

    }


    public function update(Request $request, $id)
    {

        $image1 = $request->product_image;
        if ($image1) {
            $banner_image1 = time().'banner.'.$image1->extension();  
            $image1->move(public_path('banner_image'), $banner_image1);
        }
        else
        {
            $banner_image1 = $request->old_banner_image;
        }

        $pages                = Blog::find($id);
        $pages->name          = $request->name;
        $pages->url_slug      = $request->url_slug;
        $pages->content       = $request->description;
        $pages->m_title       = $request->meta_title;
        $pages->description   = $request->meta_description;
        $pages->keyword       = $request->meta_keyword;
        $pages->image         = $banner_image1;
        $pages->status        = $request->status;
        
        if ($pages->save()) {

            return redirect()->route('admin.blog.view')->with('success', 'Blog Edited Successfully');
        }
        return redirect()->back();
    }
}
