<?php

namespace App\Console\Commands;

use App\Models\Task;
use App\Models\TaskDetails;
use App\Models\Notification;
use Illuminate\Console\Command;

class OverDueDailyUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'over:due';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        

        $task = TaskStaff::where('task_type', 'custom')->where('status', 'inprogress')->get();
        $task_details = Task::where('task_type', 'recurring')->where('status', 'inprogress')->get();
        // dd($task);
        $task1 = TaskStaff::where('task_type', 'custom')->where('status', 'over_due')->get();
        foreach ($task as $key => $value) {

            //calculate to before date
            $form_date = date('Y-m-d', strtotime($value->end_date));
            $my_time = date('Y-m-d');

            if ($form_date < $my_time) {
                $task = TaskStaff::find($value->id);
                $task->status = "over_due";
                if ($task->save()) {
                    $message_box = "Over Due Alert!";
                    $notification1                = new Notification();
                    $notification1->task_id       = $value->task_id;
                    $notification1->receiver_id   = $value->staff_id;
                    $notification1->receiver_type = "staff";
                    $notification1->message       = $message_box;
                    $notification1->status        = 0;
                    $notification1->save();
                }

                \Log::info($value->id.' Alert Send Successfully!');
            }
            
        }
        foreach ($task1 as $key => $value) {

            $message_box = $value->task_no.' Over Due Alert!';
            $notification1                = new Notification();
            $notification1->task_id       = $value->id;
            $notification1->receiver_id   = $value->staff_id;
            $notification1->receiver_type = "staff";
            $notification1->message       = $message_box;
            $notification1->status        = 0;
            $notification1->save();
            
        }

        foreach ($task_details as $key => $value1) {

            //calculate to before date
            $form_date1 = date('Y-m-d', strtotime($value1->end_date));
            $my_time1 = date('Y-m-d');

            // dump($form_date1);
            if ($form_date1 < $my_time1) {
                $task = Task::find($value1->id);
                $task->status = "over_due";
                $task->save();
                if ($task->save()) {
                    $message_box = "Over Due Alert!";
                    $notification1                = new Notification();
                    $notification1->task_id       = $value1->id;
                    $notification1->receiver_id   = $value1->staff_id;
                    $notification1->receiver_type = "staff";
                    $notification1->message       = $message_box;
                    $notification1->status        = 0;
                    $notification1->save();
                }

                \Log::info($value1->id.' Alert Send Successfully!');
            }
            
        }

        $task_details1 = TaskDetails::where('task_type', 'recurring')->where('status', 'inprogress')->get();
        foreach ($task_details1 as $key => $value2) {
            
            //calculate to before date
            $end_date = $value2->end_date;
            $date1 = \Carbon\Carbon::create($value2->end_date);
            $daysAdd = 3;
            $date2 = $date1->subDays($daysAdd);
            $to_date = $date2->format('d-m-Y');
            

            $to = \Carbon\Carbon::parse(date('d-m-Y'));
            $from = \Carbon\Carbon::parse($to_date);

            $date23 = $to->diffInDays($from);
            // dump($date23);
            if ($date23 == 3) {
                $message_box = $value2->name.' - Recurring Task Due Date in 3 Days';
                $notification1                = new Notification();
                $notification1->task_id       = $value2->id;
                $notification1->receiver_id   = $value2->staff_id;
                $notification1->receiver_type = "staff";
                $notification1->message       = $message_box;
                $notification1->status        = 0;
                $notification1->save();
                \Log::info($value2->id.' Due Alert 3 day Send Successfully!');
            }
            elseif ($date23 == 2)
            {
                $message_box = $value2->name.' - Recurring Task Due Date in 2 Days';
                $notification1                = new Notification();
                $notification1->task_id       = $value2->id;
                $notification1->receiver_id   = $value2->staff_id;
                $notification1->receiver_type = "staff";
                $notification1->message       = $message_box;
                $notification1->status        = 0;
                $notification1->save();
                \Log::info($value2->id.' Due Alert 2 day Send Successfully!');
            }
            elseif ($date23 == 1)
            {
                $message_box = $value2->name.' - Recurring Task Over Due Date in 1 Days';
                $notification1                = new Notification();
                $notification1->task_id       = $value2->id;
                $notification1->receiver_id   = $value2->staff_id;
                $notification1->receiver_type = "staff";
                $notification1->message       = $message_box;
                $notification1->status        = 0;
                $notification1->save();
                \Log::info($value2->id.' Due Alert 1 day Send Successfully!');
            }
            else{
            }
        }

    }
}
